package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Domain111;
import com.xforceplus.ultraman.app.sdktest.service.IDomain111Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Domain111Controller {

  @Autowired
  private IDomain111Service domain111ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param domain111 ${table.comment}
   * @return
   */
  @GetMapping("/domain111s" )
  public XfR getDomain111s(XfPage page, Domain111 domain111) {
    return XfR.ok(domain111ServiceImpl.page(page, Wrappers.query(domain111)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/domain111s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(domain111ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param domain111 ${table.comment}
   * @return XfR
   */
  @PostMapping("/domain111s")
  public XfR save(@RequestBody Domain111 domain111) {
     return XfR.ok(domain111ServiceImpl.save(domain111));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param domain111 ${table.comment}
   * @return XfR
   */
  @PutMapping("/domain111s/{id}")
  public XfR putUpdate(@RequestBody Domain111 domain111,@PathVariable Long id) {
      domain111.setId(id);
      return XfR.ok(domain111ServiceImpl.updateById(domain111));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param domain111 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/domain111s/{id}")
  public XfR patchUpdate(@RequestBody Domain111 domain111,@PathVariable Long id) {
      Domain111 updomain111 = domain111ServiceImpl.getById(id);
      if(updomain111 != null){
        updomain111 = ObjectCopyUtils.copyProperties(domain111,updomain111,true);
      }
      return XfR.ok(domain111ServiceImpl.updateById(updomain111));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/domain111s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(domain111ServiceImpl.removeById(id));
  }

  @PostMapping("/domain111s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(domain111ServiceImpl.querys(params));
  }

}
