package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Domain123;
import com.xforceplus.ultraman.app.sdktest.service.IDomain123Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Domain123Controller {

  @Autowired
  private IDomain123Service domain123ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param domain123 ${table.comment}
   * @return
   */
  @GetMapping("/domain123s" )
  public XfR getDomain123s(XfPage page, Domain123 domain123) {
    return XfR.ok(domain123ServiceImpl.page(page, Wrappers.query(domain123)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/domain123s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(domain123ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param domain123 ${table.comment}
   * @return XfR
   */
  @PostMapping("/domain123s")
  public XfR save(@RequestBody Domain123 domain123) {
     return XfR.ok(domain123ServiceImpl.save(domain123));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param domain123 ${table.comment}
   * @return XfR
   */
  @PutMapping("/domain123s/{id}")
  public XfR putUpdate(@RequestBody Domain123 domain123,@PathVariable Long id) {
      domain123.setId(id);
      return XfR.ok(domain123ServiceImpl.updateById(domain123));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param domain123 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/domain123s/{id}")
  public XfR patchUpdate(@RequestBody Domain123 domain123,@PathVariable Long id) {
      Domain123 updomain123 = domain123ServiceImpl.getById(id);
      if(updomain123 != null){
        updomain123 = ObjectCopyUtils.copyProperties(domain123,updomain123,true);
      }
      return XfR.ok(domain123ServiceImpl.updateById(updomain123));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/domain123s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(domain123ServiceImpl.removeById(id));
  }

  @PostMapping("/domain123s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(domain123ServiceImpl.querys(params));
  }

}
