package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Domain222;
import com.xforceplus.ultraman.app.sdktest.service.IDomain222Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Domain222Controller {

  @Autowired
  private IDomain222Service domain222ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param domain222 ${table.comment}
   * @return
   */
  @GetMapping("/domain222s" )
  public XfR getDomain222s(XfPage page, Domain222 domain222) {
    return XfR.ok(domain222ServiceImpl.page(page, Wrappers.query(domain222)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/domain222s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(domain222ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param domain222 ${table.comment}
   * @return XfR
   */
  @PostMapping("/domain222s")
  public XfR save(@RequestBody Domain222 domain222) {
     return XfR.ok(domain222ServiceImpl.save(domain222));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param domain222 ${table.comment}
   * @return XfR
   */
  @PutMapping("/domain222s/{id}")
  public XfR putUpdate(@RequestBody Domain222 domain222,@PathVariable Long id) {
      domain222.setId(id);
      return XfR.ok(domain222ServiceImpl.updateById(domain222));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param domain222 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/domain222s/{id}")
  public XfR patchUpdate(@RequestBody Domain222 domain222,@PathVariable Long id) {
      Domain222 updomain222 = domain222ServiceImpl.getById(id);
      if(updomain222 != null){
        updomain222 = ObjectCopyUtils.copyProperties(domain222,updomain222,true);
      }
      return XfR.ok(domain222ServiceImpl.updateById(updomain222));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/domain222s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(domain222ServiceImpl.removeById(id));
  }

  @PostMapping("/domain222s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(domain222ServiceImpl.querys(params));
  }

}
