package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Domain333;
import com.xforceplus.ultraman.app.sdktest.service.IDomain333Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Domain333Controller {

  @Autowired
  private IDomain333Service domain333ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param domain333 ${table.comment}
   * @return
   */
  @GetMapping("/domain333s" )
  public XfR getDomain333s(XfPage page, Domain333 domain333) {
    return XfR.ok(domain333ServiceImpl.page(page, Wrappers.query(domain333)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/domain333s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(domain333ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param domain333 ${table.comment}
   * @return XfR
   */
  @PostMapping("/domain333s")
  public XfR save(@RequestBody Domain333 domain333) {
     return XfR.ok(domain333ServiceImpl.save(domain333));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param domain333 ${table.comment}
   * @return XfR
   */
  @PutMapping("/domain333s/{id}")
  public XfR putUpdate(@RequestBody Domain333 domain333,@PathVariable Long id) {
      domain333.setId(id);
      return XfR.ok(domain333ServiceImpl.updateById(domain333));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param domain333 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/domain333s/{id}")
  public XfR patchUpdate(@RequestBody Domain333 domain333,@PathVariable Long id) {
      Domain333 updomain333 = domain333ServiceImpl.getById(id);
      if(updomain333 != null){
        updomain333 = ObjectCopyUtils.copyProperties(domain333,updomain333,true);
      }
      return XfR.ok(domain333ServiceImpl.updateById(updomain333));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/domain333s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(domain333ServiceImpl.removeById(id));
  }

  @PostMapping("/domain333s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(domain333ServiceImpl.querys(params));
  }

}
