package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ExtendMainChild1;
import com.xforceplus.ultraman.app.sdktest.service.IExtendMainChild1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ExtendMainChild1Controller {

  @Autowired
  private IExtendMainChild1Service extendMainChild1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param extendMainChild1 ${table.comment}
   * @return
   */
  @GetMapping("/extendmainchild1s" )
  public XfR getExtendMainChild1s(XfPage page, ExtendMainChild1 extendMainChild1) {
    return XfR.ok(extendMainChild1ServiceImpl.page(page, Wrappers.query(extendMainChild1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/extendmainchild1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(extendMainChild1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param extendMainChild1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/extendmainchild1s")
  public XfR save(@RequestBody ExtendMainChild1 extendMainChild1) {
     return XfR.ok(extendMainChild1ServiceImpl.save(extendMainChild1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param extendMainChild1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/extendmainchild1s/{id}")
  public XfR putUpdate(@RequestBody ExtendMainChild1 extendMainChild1,@PathVariable Long id) {
      extendMainChild1.setId(id);
      return XfR.ok(extendMainChild1ServiceImpl.updateById(extendMainChild1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param extendMainChild1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/extendmainchild1s/{id}")
  public XfR patchUpdate(@RequestBody ExtendMainChild1 extendMainChild1,@PathVariable Long id) {
      ExtendMainChild1 upextendMainChild1 = extendMainChild1ServiceImpl.getById(id);
      if(upextendMainChild1 != null){
        upextendMainChild1 = ObjectCopyUtils.copyProperties(extendMainChild1,upextendMainChild1,true);
      }
      return XfR.ok(extendMainChild1ServiceImpl.updateById(upextendMainChild1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/extendmainchild1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(extendMainChild1ServiceImpl.removeById(id));
  }

  @PostMapping("/extendmainchild1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "extend_main_child1");
     params.put("request", condition);

     return XfR.ok(extendMainChild1ServiceImpl.querys(params));
  }

}
