package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ExtendMainChild2;
import com.xforceplus.ultraman.app.sdktest.service.IExtendMainChild2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ExtendMainChild2Controller {

  @Autowired
  private IExtendMainChild2Service extendMainChild2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param extendMainChild2 ${table.comment}
   * @return
   */
  @GetMapping("/extendmainchild2s" )
  public XfR getExtendMainChild2s(XfPage page, ExtendMainChild2 extendMainChild2) {
    return XfR.ok(extendMainChild2ServiceImpl.page(page, Wrappers.query(extendMainChild2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/extendmainchild2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(extendMainChild2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param extendMainChild2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/extendmainchild2s")
  public XfR save(@RequestBody ExtendMainChild2 extendMainChild2) {
     return XfR.ok(extendMainChild2ServiceImpl.save(extendMainChild2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param extendMainChild2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/extendmainchild2s/{id}")
  public XfR putUpdate(@RequestBody ExtendMainChild2 extendMainChild2,@PathVariable Long id) {
      extendMainChild2.setId(id);
      return XfR.ok(extendMainChild2ServiceImpl.updateById(extendMainChild2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param extendMainChild2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/extendmainchild2s/{id}")
  public XfR patchUpdate(@RequestBody ExtendMainChild2 extendMainChild2,@PathVariable Long id) {
      ExtendMainChild2 upextendMainChild2 = extendMainChild2ServiceImpl.getById(id);
      if(upextendMainChild2 != null){
        upextendMainChild2 = ObjectCopyUtils.copyProperties(extendMainChild2,upextendMainChild2,true);
      }
      return XfR.ok(extendMainChild2ServiceImpl.updateById(upextendMainChild2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/extendmainchild2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(extendMainChild2ServiceImpl.removeById(id));
  }

  @PostMapping("/extendmainchild2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "extend_main_child2");
     params.put("request", condition);

     return XfR.ok(extendMainChild2ServiceImpl.querys(params));
  }

}
