package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.FormulaEntity;
import com.xforceplus.ultraman.app.sdktest.service.IFormulaEntityService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class FormulaEntityController {

  @Autowired
  private IFormulaEntityService formulaEntityServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param formulaEntity ${table.comment}
   * @return
   */
  @GetMapping("/formulaentitys" )
  public XfR getFormulaEntitys(XfPage page, FormulaEntity formulaEntity) {
    return XfR.ok(formulaEntityServiceImpl.page(page, Wrappers.query(formulaEntity)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/formulaentitys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(formulaEntityServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param formulaEntity ${table.comment}
   * @return XfR
   */
  @PostMapping("/formulaentitys")
  public XfR save(@RequestBody FormulaEntity formulaEntity) {
     return XfR.ok(formulaEntityServiceImpl.save(formulaEntity));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param formulaEntity ${table.comment}
   * @return XfR
   */
  @PutMapping("/formulaentitys/{id}")
  public XfR putUpdate(@RequestBody FormulaEntity formulaEntity,@PathVariable Long id) {
      formulaEntity.setId(id);
      return XfR.ok(formulaEntityServiceImpl.updateById(formulaEntity));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param formulaEntity ${table.comment}
   * @return XfR
   */
  @PatchMapping("/formulaentitys/{id}")
  public XfR patchUpdate(@RequestBody FormulaEntity formulaEntity,@PathVariable Long id) {
      FormulaEntity upformulaEntity = formulaEntityServiceImpl.getById(id);
      if(upformulaEntity != null){
        upformulaEntity = ObjectCopyUtils.copyProperties(formulaEntity,upformulaEntity,true);
      }
      return XfR.ok(formulaEntityServiceImpl.updateById(upformulaEntity));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/formulaentitys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(formulaEntityServiceImpl.removeById(id));
  }

  @PostMapping("/formulaentitys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "formula_entity");
     params.put("request", condition);

     return XfR.ok(formulaEntityServiceImpl.querys(params));
  }

}
