package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.GrandChild;
import com.xforceplus.ultraman.app.sdktest.service.IGrandChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class GrandChildController {

  @Autowired
  private IGrandChildService grandChildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param grandChild ${table.comment}
   * @return
   */
  @GetMapping("/grandchilds" )
  public XfR getGrandChilds(XfPage page, GrandChild grandChild) {
    return XfR.ok(grandChildServiceImpl.page(page, Wrappers.query(grandChild)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/grandchilds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(grandChildServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param grandChild ${table.comment}
   * @return XfR
   */
  @PostMapping("/grandchilds")
  public XfR save(@RequestBody GrandChild grandChild) {
     return XfR.ok(grandChildServiceImpl.save(grandChild));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param grandChild ${table.comment}
   * @return XfR
   */
  @PutMapping("/grandchilds/{id}")
  public XfR putUpdate(@RequestBody GrandChild grandChild,@PathVariable Long id) {
      grandChild.setId(id);
      return XfR.ok(grandChildServiceImpl.updateById(grandChild));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param grandChild ${table.comment}
   * @return XfR
   */
  @PatchMapping("/grandchilds/{id}")
  public XfR patchUpdate(@RequestBody GrandChild grandChild,@PathVariable Long id) {
      GrandChild upgrandChild = grandChildServiceImpl.getById(id);
      if(upgrandChild != null){
        upgrandChild = ObjectCopyUtils.copyProperties(grandChild,upgrandChild,true);
      }
      return XfR.ok(grandChildServiceImpl.updateById(upgrandChild));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/grandchilds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(grandChildServiceImpl.removeById(id));
  }

  @PostMapping("/grandchilds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "grand_child");
     params.put("request", condition);

     return XfR.ok(grandChildServiceImpl.querys(params));
  }

}
