package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ImportObj;
import com.xforceplus.ultraman.app.sdktest.service.IImportObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ImportObjController {

  @Autowired
  private IImportObjService importObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importObj ${table.comment}
   * @return
   */
  @GetMapping("/importobjs" )
  public XfR getImportObjs(XfPage page, ImportObj importObj) {
    return XfR.ok(importObjServiceImpl.page(page, Wrappers.query(importObj)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importObjServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importObj ${table.comment}
   * @return XfR
   */
  @PostMapping("/importobjs")
  public XfR save(@RequestBody ImportObj importObj) {
     return XfR.ok(importObjServiceImpl.save(importObj));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importObj ${table.comment}
   * @return XfR
   */
  @PutMapping("/importobjs/{id}")
  public XfR putUpdate(@RequestBody ImportObj importObj,@PathVariable Long id) {
      importObj.setId(id);
      return XfR.ok(importObjServiceImpl.updateById(importObj));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importObj ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importobjs/{id}")
  public XfR patchUpdate(@RequestBody ImportObj importObj,@PathVariable Long id) {
      ImportObj upimportObj = importObjServiceImpl.getById(id);
      if(upimportObj != null){
        upimportObj = ObjectCopyUtils.copyProperties(importObj,upimportObj,true);
      }
      return XfR.ok(importObjServiceImpl.updateById(upimportObj));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importObjServiceImpl.removeById(id));
  }

  @PostMapping("/importobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_obj");
     params.put("request", condition);

     return XfR.ok(importObjServiceImpl.querys(params));
  }

}
