package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Inv;
import com.xforceplus.ultraman.app.sdktest.service.IInvService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class InvController {

  @Autowired
  private IInvService invServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inv ${table.comment}
   * @return
   */
  @GetMapping("/invs" )
  public XfR getInvs(XfPage page, Inv inv) {
    return XfR.ok(invServiceImpl.page(page, Wrappers.query(inv)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inv ${table.comment}
   * @return XfR
   */
  @PostMapping("/invs")
  public XfR save(@RequestBody Inv inv) {
     return XfR.ok(invServiceImpl.save(inv));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inv ${table.comment}
   * @return XfR
   */
  @PutMapping("/invs/{id}")
  public XfR putUpdate(@RequestBody Inv inv,@PathVariable Long id) {
      inv.setId(id);
      return XfR.ok(invServiceImpl.updateById(inv));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inv ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invs/{id}")
  public XfR patchUpdate(@RequestBody Inv inv,@PathVariable Long id) {
      Inv upinv = invServiceImpl.getById(id);
      if(upinv != null){
        upinv = ObjectCopyUtils.copyProperties(inv,upinv,true);
      }
      return XfR.ok(invServiceImpl.updateById(upinv));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invServiceImpl.removeById(id));
  }

  @PostMapping("/invs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv");
     params.put("request", condition);

     return XfR.ok(invServiceImpl.querys(params));
  }

}
