package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.InvoiceBill;
import com.xforceplus.ultraman.app.sdktest.service.IInvoiceBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class InvoiceBillController {

  @Autowired
  private IInvoiceBillService invoiceBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceBill ${table.comment}
   * @return
   */
  @GetMapping("/invoicebills" )
  public XfR getInvoiceBills(XfPage page, InvoiceBill invoiceBill) {
    return XfR.ok(invoiceBillServiceImpl.page(page, Wrappers.query(invoiceBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicebills")
  public XfR save(@RequestBody InvoiceBill invoiceBill) {
     return XfR.ok(invoiceBillServiceImpl.save(invoiceBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicebills/{id}")
  public XfR putUpdate(@RequestBody InvoiceBill invoiceBill,@PathVariable Long id) {
      invoiceBill.setId(id);
      return XfR.ok(invoiceBillServiceImpl.updateById(invoiceBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicebills/{id}")
  public XfR patchUpdate(@RequestBody InvoiceBill invoiceBill,@PathVariable Long id) {
      InvoiceBill upinvoiceBill = invoiceBillServiceImpl.getById(id);
      if(upinvoiceBill != null){
        upinvoiceBill = ObjectCopyUtils.copyProperties(invoiceBill,upinvoiceBill,true);
      }
      return XfR.ok(invoiceBillServiceImpl.updateById(upinvoiceBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceBillServiceImpl.removeById(id));
  }

  @PostMapping("/invoicebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_bill");
     params.put("request", condition);

     return XfR.ok(invoiceBillServiceImpl.querys(params));
  }

}
