package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Mobiletest;
import com.xforceplus.ultraman.app.sdktest.service.IMobiletestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class MobiletestController {

  @Autowired
  private IMobiletestService mobiletestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mobiletest ${table.comment}
   * @return
   */
  @GetMapping("/mobiletests" )
  public XfR getMobiletests(XfPage page, Mobiletest mobiletest) {
    return XfR.ok(mobiletestServiceImpl.page(page, Wrappers.query(mobiletest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mobiletests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mobiletestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param mobiletest ${table.comment}
   * @return XfR
   */
  @PostMapping("/mobiletests")
  public XfR save(@RequestBody Mobiletest mobiletest) {
     return XfR.ok(mobiletestServiceImpl.save(mobiletest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param mobiletest ${table.comment}
   * @return XfR
   */
  @PutMapping("/mobiletests/{id}")
  public XfR putUpdate(@RequestBody Mobiletest mobiletest,@PathVariable Long id) {
      mobiletest.setId(id);
      return XfR.ok(mobiletestServiceImpl.updateById(mobiletest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param mobiletest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mobiletests/{id}")
  public XfR patchUpdate(@RequestBody Mobiletest mobiletest,@PathVariable Long id) {
      Mobiletest upmobiletest = mobiletestServiceImpl.getById(id);
      if(upmobiletest != null){
        upmobiletest = ObjectCopyUtils.copyProperties(mobiletest,upmobiletest,true);
      }
      return XfR.ok(mobiletestServiceImpl.updateById(upmobiletest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mobiletests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mobiletestServiceImpl.removeById(id));
  }

  @PostMapping("/mobiletests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mobiletest");
     params.put("request", condition);

     return XfR.ok(mobiletestServiceImpl.querys(params));
  }

}
