package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ObjectIndex;
import com.xforceplus.ultraman.app.sdktest.service.IObjectIndexService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ObjectIndexController {

  @Autowired
  private IObjectIndexService objectIndexServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param objectIndex ${table.comment}
   * @return
   */
  @GetMapping("/objectindexs" )
  public XfR getObjectIndexs(XfPage page, ObjectIndex objectIndex) {
    return XfR.ok(objectIndexServiceImpl.page(page, Wrappers.query(objectIndex)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/objectindexs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(objectIndexServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param objectIndex ${table.comment}
   * @return XfR
   */
  @PostMapping("/objectindexs")
  public XfR save(@RequestBody ObjectIndex objectIndex) {
     return XfR.ok(objectIndexServiceImpl.save(objectIndex));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param objectIndex ${table.comment}
   * @return XfR
   */
  @PutMapping("/objectindexs/{id}")
  public XfR putUpdate(@RequestBody ObjectIndex objectIndex,@PathVariable Long id) {
      objectIndex.setId(id);
      return XfR.ok(objectIndexServiceImpl.updateById(objectIndex));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param objectIndex ${table.comment}
   * @return XfR
   */
  @PatchMapping("/objectindexs/{id}")
  public XfR patchUpdate(@RequestBody ObjectIndex objectIndex,@PathVariable Long id) {
      ObjectIndex upobjectIndex = objectIndexServiceImpl.getById(id);
      if(upobjectIndex != null){
        upobjectIndex = ObjectCopyUtils.copyProperties(objectIndex,upobjectIndex,true);
      }
      return XfR.ok(objectIndexServiceImpl.updateById(upobjectIndex));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/objectindexs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(objectIndexServiceImpl.removeById(id));
  }

  @PostMapping("/objectindexs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "object_index");
     params.put("request", condition);

     return XfR.ok(objectIndexServiceImpl.querys(params));
  }

}
