package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.OqsBo110334;
import com.xforceplus.ultraman.app.sdktest.service.IOqsBo110334Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class OqsBo110334Controller {

  @Autowired
  private IOqsBo110334Service oqsBo110334ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsBo110334 ${table.comment}
   * @return
   */
  @GetMapping("/oqsbo110334s" )
  public XfR getOqsBo110334s(XfPage page, OqsBo110334 oqsBo110334) {
    return XfR.ok(oqsBo110334ServiceImpl.page(page, Wrappers.query(oqsBo110334)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqsbo110334s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsBo110334ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oqsBo110334 ${table.comment}
   * @return XfR
   */
  @PostMapping("/oqsbo110334s")
  public XfR save(@RequestBody OqsBo110334 oqsBo110334) {
     return XfR.ok(oqsBo110334ServiceImpl.save(oqsBo110334));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oqsBo110334 ${table.comment}
   * @return XfR
   */
  @PutMapping("/oqsbo110334s/{id}")
  public XfR putUpdate(@RequestBody OqsBo110334 oqsBo110334,@PathVariable Long id) {
      oqsBo110334.setId(id);
      return XfR.ok(oqsBo110334ServiceImpl.updateById(oqsBo110334));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oqsBo110334 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oqsbo110334s/{id}")
  public XfR patchUpdate(@RequestBody OqsBo110334 oqsBo110334,@PathVariable Long id) {
      OqsBo110334 upoqsBo110334 = oqsBo110334ServiceImpl.getById(id);
      if(upoqsBo110334 != null){
        upoqsBo110334 = ObjectCopyUtils.copyProperties(oqsBo110334,upoqsBo110334,true);
      }
      return XfR.ok(oqsBo110334ServiceImpl.updateById(upoqsBo110334));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqsbo110334s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsBo110334ServiceImpl.removeById(id));
  }

  @PostMapping("/oqsbo110334s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqs_bo110334");
     params.put("request", condition);

     return XfR.ok(oqsBo110334ServiceImpl.querys(params));
  }

}
