package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.OqsBo130800;
import com.xforceplus.ultraman.app.sdktest.service.IOqsBo130800Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class OqsBo130800Controller {

  @Autowired
  private IOqsBo130800Service oqsBo130800ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsBo130800 ${table.comment}
   * @return
   */
  @GetMapping("/oqsbo130800s" )
  public XfR getOqsBo130800s(XfPage page, OqsBo130800 oqsBo130800) {
    return XfR.ok(oqsBo130800ServiceImpl.page(page, Wrappers.query(oqsBo130800)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqsbo130800s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsBo130800ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oqsBo130800 ${table.comment}
   * @return XfR
   */
  @PostMapping("/oqsbo130800s")
  public XfR save(@RequestBody OqsBo130800 oqsBo130800) {
     return XfR.ok(oqsBo130800ServiceImpl.save(oqsBo130800));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oqsBo130800 ${table.comment}
   * @return XfR
   */
  @PutMapping("/oqsbo130800s/{id}")
  public XfR putUpdate(@RequestBody OqsBo130800 oqsBo130800,@PathVariable Long id) {
      oqsBo130800.setId(id);
      return XfR.ok(oqsBo130800ServiceImpl.updateById(oqsBo130800));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oqsBo130800 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oqsbo130800s/{id}")
  public XfR patchUpdate(@RequestBody OqsBo130800 oqsBo130800,@PathVariable Long id) {
      OqsBo130800 upoqsBo130800 = oqsBo130800ServiceImpl.getById(id);
      if(upoqsBo130800 != null){
        upoqsBo130800 = ObjectCopyUtils.copyProperties(oqsBo130800,upoqsBo130800,true);
      }
      return XfR.ok(oqsBo130800ServiceImpl.updateById(upoqsBo130800));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqsbo130800s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsBo130800ServiceImpl.removeById(id));
  }

  @PostMapping("/oqsbo130800s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqs_bo130800");
     params.put("request", condition);

     return XfR.ok(oqsBo130800ServiceImpl.querys(params));
  }

}
