package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.OqsBo147672;
import com.xforceplus.ultraman.app.sdktest.service.IOqsBo147672Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class OqsBo147672Controller {

  @Autowired
  private IOqsBo147672Service oqsBo147672ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsBo147672 ${table.comment}
   * @return
   */
  @GetMapping("/oqsbo147672s" )
  public XfR getOqsBo147672s(XfPage page, OqsBo147672 oqsBo147672) {
    return XfR.ok(oqsBo147672ServiceImpl.page(page, Wrappers.query(oqsBo147672)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqsbo147672s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsBo147672ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oqsBo147672 ${table.comment}
   * @return XfR
   */
  @PostMapping("/oqsbo147672s")
  public XfR save(@RequestBody OqsBo147672 oqsBo147672) {
     return XfR.ok(oqsBo147672ServiceImpl.save(oqsBo147672));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oqsBo147672 ${table.comment}
   * @return XfR
   */
  @PutMapping("/oqsbo147672s/{id}")
  public XfR putUpdate(@RequestBody OqsBo147672 oqsBo147672,@PathVariable Long id) {
      oqsBo147672.setId(id);
      return XfR.ok(oqsBo147672ServiceImpl.updateById(oqsBo147672));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oqsBo147672 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oqsbo147672s/{id}")
  public XfR patchUpdate(@RequestBody OqsBo147672 oqsBo147672,@PathVariable Long id) {
      OqsBo147672 upoqsBo147672 = oqsBo147672ServiceImpl.getById(id);
      if(upoqsBo147672 != null){
        upoqsBo147672 = ObjectCopyUtils.copyProperties(oqsBo147672,upoqsBo147672,true);
      }
      return XfR.ok(oqsBo147672ServiceImpl.updateById(upoqsBo147672));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqsbo147672s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsBo147672ServiceImpl.removeById(id));
  }

  @PostMapping("/oqsbo147672s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqs_bo147672");
     params.put("request", condition);

     return XfR.ok(oqsBo147672ServiceImpl.querys(params));
  }

}
