package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.OqsBo190612;
import com.xforceplus.ultraman.app.sdktest.service.IOqsBo190612Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class OqsBo190612Controller {

  @Autowired
  private IOqsBo190612Service oqsBo190612ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsBo190612 ${table.comment}
   * @return
   */
  @GetMapping("/oqsbo190612s" )
  public XfR getOqsBo190612s(XfPage page, OqsBo190612 oqsBo190612) {
    return XfR.ok(oqsBo190612ServiceImpl.page(page, Wrappers.query(oqsBo190612)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqsbo190612s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsBo190612ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oqsBo190612 ${table.comment}
   * @return XfR
   */
  @PostMapping("/oqsbo190612s")
  public XfR save(@RequestBody OqsBo190612 oqsBo190612) {
     return XfR.ok(oqsBo190612ServiceImpl.save(oqsBo190612));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oqsBo190612 ${table.comment}
   * @return XfR
   */
  @PutMapping("/oqsbo190612s/{id}")
  public XfR putUpdate(@RequestBody OqsBo190612 oqsBo190612,@PathVariable Long id) {
      oqsBo190612.setId(id);
      return XfR.ok(oqsBo190612ServiceImpl.updateById(oqsBo190612));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oqsBo190612 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oqsbo190612s/{id}")
  public XfR patchUpdate(@RequestBody OqsBo190612 oqsBo190612,@PathVariable Long id) {
      OqsBo190612 upoqsBo190612 = oqsBo190612ServiceImpl.getById(id);
      if(upoqsBo190612 != null){
        upoqsBo190612 = ObjectCopyUtils.copyProperties(oqsBo190612,upoqsBo190612,true);
      }
      return XfR.ok(oqsBo190612ServiceImpl.updateById(upoqsBo190612));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqsbo190612s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsBo190612ServiceImpl.removeById(id));
  }

  @PostMapping("/oqsbo190612s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqs_bo190612");
     params.put("request", condition);

     return XfR.ok(oqsBo190612ServiceImpl.querys(params));
  }

}
