package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.OqsBo212703;
import com.xforceplus.ultraman.app.sdktest.service.IOqsBo212703Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class OqsBo212703Controller {

  @Autowired
  private IOqsBo212703Service oqsBo212703ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsBo212703 ${table.comment}
   * @return
   */
  @GetMapping("/oqsbo212703s" )
  public XfR getOqsBo212703s(XfPage page, OqsBo212703 oqsBo212703) {
    return XfR.ok(oqsBo212703ServiceImpl.page(page, Wrappers.query(oqsBo212703)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqsbo212703s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsBo212703ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oqsBo212703 ${table.comment}
   * @return XfR
   */
  @PostMapping("/oqsbo212703s")
  public XfR save(@RequestBody OqsBo212703 oqsBo212703) {
     return XfR.ok(oqsBo212703ServiceImpl.save(oqsBo212703));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oqsBo212703 ${table.comment}
   * @return XfR
   */
  @PutMapping("/oqsbo212703s/{id}")
  public XfR putUpdate(@RequestBody OqsBo212703 oqsBo212703,@PathVariable Long id) {
      oqsBo212703.setId(id);
      return XfR.ok(oqsBo212703ServiceImpl.updateById(oqsBo212703));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oqsBo212703 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oqsbo212703s/{id}")
  public XfR patchUpdate(@RequestBody OqsBo212703 oqsBo212703,@PathVariable Long id) {
      OqsBo212703 upoqsBo212703 = oqsBo212703ServiceImpl.getById(id);
      if(upoqsBo212703 != null){
        upoqsBo212703 = ObjectCopyUtils.copyProperties(oqsBo212703,upoqsBo212703,true);
      }
      return XfR.ok(oqsBo212703ServiceImpl.updateById(upoqsBo212703));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqsbo212703s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsBo212703ServiceImpl.removeById(id));
  }

  @PostMapping("/oqsbo212703s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqs_bo212703");
     params.put("request", condition);

     return XfR.ok(oqsBo212703ServiceImpl.querys(params));
  }

}
