package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.OqsBo250147;
import com.xforceplus.ultraman.app.sdktest.service.IOqsBo250147Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class OqsBo250147Controller {

  @Autowired
  private IOqsBo250147Service oqsBo250147ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsBo250147 ${table.comment}
   * @return
   */
  @GetMapping("/oqsbo250147s" )
  public XfR getOqsBo250147s(XfPage page, OqsBo250147 oqsBo250147) {
    return XfR.ok(oqsBo250147ServiceImpl.page(page, Wrappers.query(oqsBo250147)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqsbo250147s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsBo250147ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oqsBo250147 ${table.comment}
   * @return XfR
   */
  @PostMapping("/oqsbo250147s")
  public XfR save(@RequestBody OqsBo250147 oqsBo250147) {
     return XfR.ok(oqsBo250147ServiceImpl.save(oqsBo250147));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oqsBo250147 ${table.comment}
   * @return XfR
   */
  @PutMapping("/oqsbo250147s/{id}")
  public XfR putUpdate(@RequestBody OqsBo250147 oqsBo250147,@PathVariable Long id) {
      oqsBo250147.setId(id);
      return XfR.ok(oqsBo250147ServiceImpl.updateById(oqsBo250147));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oqsBo250147 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oqsbo250147s/{id}")
  public XfR patchUpdate(@RequestBody OqsBo250147 oqsBo250147,@PathVariable Long id) {
      OqsBo250147 upoqsBo250147 = oqsBo250147ServiceImpl.getById(id);
      if(upoqsBo250147 != null){
        upoqsBo250147 = ObjectCopyUtils.copyProperties(oqsBo250147,upoqsBo250147,true);
      }
      return XfR.ok(oqsBo250147ServiceImpl.updateById(upoqsBo250147));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqsbo250147s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsBo250147ServiceImpl.removeById(id));
  }

  @PostMapping("/oqsbo250147s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqs_bo250147");
     params.put("request", condition);

     return XfR.ok(oqsBo250147ServiceImpl.querys(params));
  }

}
