package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.PL1;
import com.xforceplus.ultraman.app.sdktest.service.IPL1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class PL1Controller {

  @Autowired
  private IPL1Service PL1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pL1 ${table.comment}
   * @return
   */
  @GetMapping("/pl1s" )
  public XfR getPL1s(XfPage page, PL1 pL1) {
    return XfR.ok(PL1ServiceImpl.page(page, Wrappers.query(pL1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pl1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(PL1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pL1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/pl1s")
  public XfR save(@RequestBody PL1 pL1) {
     return XfR.ok(PL1ServiceImpl.save(pL1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pL1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/pl1s/{id}")
  public XfR putUpdate(@RequestBody PL1 pL1,@PathVariable Long id) {
      pL1.setId(id);
      return XfR.ok(PL1ServiceImpl.updateById(pL1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pL1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pl1s/{id}")
  public XfR patchUpdate(@RequestBody PL1 pL1,@PathVariable Long id) {
      PL1 uppL1 = PL1ServiceImpl.getById(id);
      if(uppL1 != null){
        uppL1 = ObjectCopyUtils.copyProperties(pL1,uppL1,true);
      }
      return XfR.ok(PL1ServiceImpl.updateById(uppL1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pl1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(PL1ServiceImpl.removeById(id));
  }

  @PostMapping("/pl1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "p_l1");
     params.put("request", condition);

     return XfR.ok(PL1ServiceImpl.querys(params));
  }

}
