package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Parent;
import com.xforceplus.ultraman.app.sdktest.service.IParentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ParentController {

  @Autowired
  private IParentService parentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parent ${table.comment}
   * @return
   */
  @GetMapping("/parents" )
  public XfR getParents(XfPage page, Parent parent) {
    return XfR.ok(parentServiceImpl.page(page, Wrappers.query(parent)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/parents/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param parent ${table.comment}
   * @return XfR
   */
  @PostMapping("/parents")
  public XfR save(@RequestBody Parent parent) {
     return XfR.ok(parentServiceImpl.save(parent));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param parent ${table.comment}
   * @return XfR
   */
  @PutMapping("/parents/{id}")
  public XfR putUpdate(@RequestBody Parent parent,@PathVariable Long id) {
      parent.setId(id);
      return XfR.ok(parentServiceImpl.updateById(parent));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param parent ${table.comment}
   * @return XfR
   */
  @PatchMapping("/parents/{id}")
  public XfR patchUpdate(@RequestBody Parent parent,@PathVariable Long id) {
      Parent upparent = parentServiceImpl.getById(id);
      if(upparent != null){
        upparent = ObjectCopyUtils.copyProperties(parent,upparent,true);
      }
      return XfR.ok(parentServiceImpl.updateById(upparent));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parents/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parentServiceImpl.removeById(id));
  }

  @PostMapping("/parents/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parent");
     params.put("request", condition);

     return XfR.ok(parentServiceImpl.querys(params));
  }

}
