package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ParentOqs25535;
import com.xforceplus.ultraman.app.sdktest.service.IParentOqs25535Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ParentOqs25535Controller {

  @Autowired
  private IParentOqs25535Service parentOqs25535ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parentOqs25535 ${table.comment}
   * @return
   */
  @GetMapping("/parentoqs25535s" )
  public XfR getParentOqs25535s(XfPage page, ParentOqs25535 parentOqs25535) {
    return XfR.ok(parentOqs25535ServiceImpl.page(page, Wrappers.query(parentOqs25535)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/parentoqs25535s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parentOqs25535ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param parentOqs25535 ${table.comment}
   * @return XfR
   */
  @PostMapping("/parentoqs25535s")
  public XfR save(@RequestBody ParentOqs25535 parentOqs25535) {
     return XfR.ok(parentOqs25535ServiceImpl.save(parentOqs25535));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param parentOqs25535 ${table.comment}
   * @return XfR
   */
  @PutMapping("/parentoqs25535s/{id}")
  public XfR putUpdate(@RequestBody ParentOqs25535 parentOqs25535,@PathVariable Long id) {
      parentOqs25535.setId(id);
      return XfR.ok(parentOqs25535ServiceImpl.updateById(parentOqs25535));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param parentOqs25535 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/parentoqs25535s/{id}")
  public XfR patchUpdate(@RequestBody ParentOqs25535 parentOqs25535,@PathVariable Long id) {
      ParentOqs25535 upparentOqs25535 = parentOqs25535ServiceImpl.getById(id);
      if(upparentOqs25535 != null){
        upparentOqs25535 = ObjectCopyUtils.copyProperties(parentOqs25535,upparentOqs25535,true);
      }
      return XfR.ok(parentOqs25535ServiceImpl.updateById(upparentOqs25535));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parentoqs25535s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parentOqs25535ServiceImpl.removeById(id));
  }

  @PostMapping("/parentoqs25535s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parent_oqs25535");
     params.put("request", condition);

     return XfR.ok(parentOqs25535ServiceImpl.querys(params));
  }

}
