package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ParentOqs40479;
import com.xforceplus.ultraman.app.sdktest.service.IParentOqs40479Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ParentOqs40479Controller {

  @Autowired
  private IParentOqs40479Service parentOqs40479ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parentOqs40479 ${table.comment}
   * @return
   */
  @GetMapping("/parentoqs40479s" )
  public XfR getParentOqs40479s(XfPage page, ParentOqs40479 parentOqs40479) {
    return XfR.ok(parentOqs40479ServiceImpl.page(page, Wrappers.query(parentOqs40479)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/parentoqs40479s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parentOqs40479ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param parentOqs40479 ${table.comment}
   * @return XfR
   */
  @PostMapping("/parentoqs40479s")
  public XfR save(@RequestBody ParentOqs40479 parentOqs40479) {
     return XfR.ok(parentOqs40479ServiceImpl.save(parentOqs40479));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param parentOqs40479 ${table.comment}
   * @return XfR
   */
  @PutMapping("/parentoqs40479s/{id}")
  public XfR putUpdate(@RequestBody ParentOqs40479 parentOqs40479,@PathVariable Long id) {
      parentOqs40479.setId(id);
      return XfR.ok(parentOqs40479ServiceImpl.updateById(parentOqs40479));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param parentOqs40479 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/parentoqs40479s/{id}")
  public XfR patchUpdate(@RequestBody ParentOqs40479 parentOqs40479,@PathVariable Long id) {
      ParentOqs40479 upparentOqs40479 = parentOqs40479ServiceImpl.getById(id);
      if(upparentOqs40479 != null){
        upparentOqs40479 = ObjectCopyUtils.copyProperties(parentOqs40479,upparentOqs40479,true);
      }
      return XfR.ok(parentOqs40479ServiceImpl.updateById(upparentOqs40479));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parentoqs40479s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parentOqs40479ServiceImpl.removeById(id));
  }

  @PostMapping("/parentoqs40479s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parent_oqs40479");
     params.put("request", condition);

     return XfR.ok(parentOqs40479ServiceImpl.querys(params));
  }

}
