package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ParentOqs4579;
import com.xforceplus.ultraman.app.sdktest.service.IParentOqs4579Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ParentOqs4579Controller {

  @Autowired
  private IParentOqs4579Service parentOqs4579ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parentOqs4579 ${table.comment}
   * @return
   */
  @GetMapping("/parentoqs4579s" )
  public XfR getParentOqs4579s(XfPage page, ParentOqs4579 parentOqs4579) {
    return XfR.ok(parentOqs4579ServiceImpl.page(page, Wrappers.query(parentOqs4579)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/parentoqs4579s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parentOqs4579ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param parentOqs4579 ${table.comment}
   * @return XfR
   */
  @PostMapping("/parentoqs4579s")
  public XfR save(@RequestBody ParentOqs4579 parentOqs4579) {
     return XfR.ok(parentOqs4579ServiceImpl.save(parentOqs4579));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param parentOqs4579 ${table.comment}
   * @return XfR
   */
  @PutMapping("/parentoqs4579s/{id}")
  public XfR putUpdate(@RequestBody ParentOqs4579 parentOqs4579,@PathVariable Long id) {
      parentOqs4579.setId(id);
      return XfR.ok(parentOqs4579ServiceImpl.updateById(parentOqs4579));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param parentOqs4579 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/parentoqs4579s/{id}")
  public XfR patchUpdate(@RequestBody ParentOqs4579 parentOqs4579,@PathVariable Long id) {
      ParentOqs4579 upparentOqs4579 = parentOqs4579ServiceImpl.getById(id);
      if(upparentOqs4579 != null){
        upparentOqs4579 = ObjectCopyUtils.copyProperties(parentOqs4579,upparentOqs4579,true);
      }
      return XfR.ok(parentOqs4579ServiceImpl.updateById(upparentOqs4579));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parentoqs4579s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parentOqs4579ServiceImpl.removeById(id));
  }

  @PostMapping("/parentoqs4579s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parent_oqs4579");
     params.put("request", condition);

     return XfR.ok(parentOqs4579ServiceImpl.querys(params));
  }

}
