package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ParentOqs84610;
import com.xforceplus.ultraman.app.sdktest.service.IParentOqs84610Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ParentOqs84610Controller {

  @Autowired
  private IParentOqs84610Service parentOqs84610ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parentOqs84610 ${table.comment}
   * @return
   */
  @GetMapping("/parentoqs84610s" )
  public XfR getParentOqs84610s(XfPage page, ParentOqs84610 parentOqs84610) {
    return XfR.ok(parentOqs84610ServiceImpl.page(page, Wrappers.query(parentOqs84610)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/parentoqs84610s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parentOqs84610ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param parentOqs84610 ${table.comment}
   * @return XfR
   */
  @PostMapping("/parentoqs84610s")
  public XfR save(@RequestBody ParentOqs84610 parentOqs84610) {
     return XfR.ok(parentOqs84610ServiceImpl.save(parentOqs84610));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param parentOqs84610 ${table.comment}
   * @return XfR
   */
  @PutMapping("/parentoqs84610s/{id}")
  public XfR putUpdate(@RequestBody ParentOqs84610 parentOqs84610,@PathVariable Long id) {
      parentOqs84610.setId(id);
      return XfR.ok(parentOqs84610ServiceImpl.updateById(parentOqs84610));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param parentOqs84610 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/parentoqs84610s/{id}")
  public XfR patchUpdate(@RequestBody ParentOqs84610 parentOqs84610,@PathVariable Long id) {
      ParentOqs84610 upparentOqs84610 = parentOqs84610ServiceImpl.getById(id);
      if(upparentOqs84610 != null){
        upparentOqs84610 = ObjectCopyUtils.copyProperties(parentOqs84610,upparentOqs84610,true);
      }
      return XfR.ok(parentOqs84610ServiceImpl.updateById(upparentOqs84610));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parentoqs84610s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parentOqs84610ServiceImpl.removeById(id));
  }

  @PostMapping("/parentoqs84610s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parent_oqs84610");
     params.put("request", condition);

     return XfR.ok(parentOqs84610ServiceImpl.querys(params));
  }

}
