package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.PersonCompany;
import com.xforceplus.ultraman.app.sdktest.service.IPersonCompanyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class PersonCompanyController {

  @Autowired
  private IPersonCompanyService personCompanyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param personCompany ${table.comment}
   * @return
   */
  @GetMapping("/personcompanys" )
  public XfR getPersonCompanys(XfPage page, PersonCompany personCompany) {
    return XfR.ok(personCompanyServiceImpl.page(page, Wrappers.query(personCompany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/personcompanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(personCompanyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param personCompany ${table.comment}
   * @return XfR
   */
  @PostMapping("/personcompanys")
  public XfR save(@RequestBody PersonCompany personCompany) {
     return XfR.ok(personCompanyServiceImpl.save(personCompany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param personCompany ${table.comment}
   * @return XfR
   */
  @PutMapping("/personcompanys/{id}")
  public XfR putUpdate(@RequestBody PersonCompany personCompany,@PathVariable Long id) {
      personCompany.setId(id);
      return XfR.ok(personCompanyServiceImpl.updateById(personCompany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param personCompany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/personcompanys/{id}")
  public XfR patchUpdate(@RequestBody PersonCompany personCompany,@PathVariable Long id) {
      PersonCompany uppersonCompany = personCompanyServiceImpl.getById(id);
      if(uppersonCompany != null){
        uppersonCompany = ObjectCopyUtils.copyProperties(personCompany,uppersonCompany,true);
      }
      return XfR.ok(personCompanyServiceImpl.updateById(uppersonCompany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/personcompanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(personCompanyServiceImpl.removeById(id));
  }

  @PostMapping("/personcompanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "person_company");
     params.put("request", condition);

     return XfR.ok(personCompanyServiceImpl.querys(params));
  }

}
