package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Route;
import com.xforceplus.ultraman.app.sdktest.service.IRouteService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class RouteController {

  @Autowired
  private IRouteService routeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param route ${table.comment}
   * @return
   */
  @GetMapping("/routes" )
  public XfR getRoutes(XfPage page, Route route) {
    return XfR.ok(routeServiceImpl.page(page, Wrappers.query(route)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/routes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(routeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param route ${table.comment}
   * @return XfR
   */
  @PostMapping("/routes")
  public XfR save(@RequestBody Route route) {
     return XfR.ok(routeServiceImpl.save(route));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param route ${table.comment}
   * @return XfR
   */
  @PutMapping("/routes/{id}")
  public XfR putUpdate(@RequestBody Route route,@PathVariable Long id) {
      route.setId(id);
      return XfR.ok(routeServiceImpl.updateById(route));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param route ${table.comment}
   * @return XfR
   */
  @PatchMapping("/routes/{id}")
  public XfR patchUpdate(@RequestBody Route route,@PathVariable Long id) {
      Route uproute = routeServiceImpl.getById(id);
      if(uproute != null){
        uproute = ObjectCopyUtils.copyProperties(route,uproute,true);
      }
      return XfR.ok(routeServiceImpl.updateById(uproute));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/routes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(routeServiceImpl.removeById(id));
  }

  @PostMapping("/routes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "route");
     params.put("request", condition);

     return XfR.ok(routeServiceImpl.querys(params));
  }

}
