package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Sdfs;
import com.xforceplus.ultraman.app.sdktest.service.ISdfsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class SdfsController {

  @Autowired
  private ISdfsService sdfsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sdfs ${table.comment}
   * @return
   */
  @GetMapping("/sdfss" )
  public XfR getSdfss(XfPage page, Sdfs sdfs) {
    return XfR.ok(sdfsServiceImpl.page(page, Wrappers.query(sdfs)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sdfss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sdfsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sdfs ${table.comment}
   * @return XfR
   */
  @PostMapping("/sdfss")
  public XfR save(@RequestBody Sdfs sdfs) {
     return XfR.ok(sdfsServiceImpl.save(sdfs));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sdfs ${table.comment}
   * @return XfR
   */
  @PutMapping("/sdfss/{id}")
  public XfR putUpdate(@RequestBody Sdfs sdfs,@PathVariable Long id) {
      sdfs.setId(id);
      return XfR.ok(sdfsServiceImpl.updateById(sdfs));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sdfs ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sdfss/{id}")
  public XfR patchUpdate(@RequestBody Sdfs sdfs,@PathVariable Long id) {
      Sdfs upsdfs = sdfsServiceImpl.getById(id);
      if(upsdfs != null){
        upsdfs = ObjectCopyUtils.copyProperties(sdfs,upsdfs,true);
      }
      return XfR.ok(sdfsServiceImpl.updateById(upsdfs));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sdfss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sdfsServiceImpl.removeById(id));
  }

  @PostMapping("/sdfss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(sdfsServiceImpl.querys(params));
  }

}
