package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Test071303;
import com.xforceplus.ultraman.app.sdktest.service.ITest071303Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Test071303Controller {

  @Autowired
  private ITest071303Service test071303ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test071303 ${table.comment}
   * @return
   */
  @GetMapping("/test071303s" )
  public XfR getTest071303s(XfPage page, Test071303 test071303) {
    return XfR.ok(test071303ServiceImpl.page(page, Wrappers.query(test071303)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test071303s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test071303ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test071303 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test071303s")
  public XfR save(@RequestBody Test071303 test071303) {
     return XfR.ok(test071303ServiceImpl.save(test071303));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test071303 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test071303s/{id}")
  public XfR putUpdate(@RequestBody Test071303 test071303,@PathVariable Long id) {
      test071303.setId(id);
      return XfR.ok(test071303ServiceImpl.updateById(test071303));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test071303 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test071303s/{id}")
  public XfR patchUpdate(@RequestBody Test071303 test071303,@PathVariable Long id) {
      Test071303 uptest071303 = test071303ServiceImpl.getById(id);
      if(uptest071303 != null){
        uptest071303 = ObjectCopyUtils.copyProperties(test071303,uptest071303,true);
      }
      return XfR.ok(test071303ServiceImpl.updateById(uptest071303));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test071303s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test071303ServiceImpl.removeById(id));
  }

  @PostMapping("/test071303s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test071303");
     params.put("request", condition);

     return XfR.ok(test071303ServiceImpl.querys(params));
  }

}
