package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Test9;
import com.xforceplus.ultraman.app.sdktest.service.ITest9Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Test9Controller {

  @Autowired
  private ITest9Service test9ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test9 ${table.comment}
   * @return
   */
  @GetMapping("/test9s" )
  public XfR getTest9s(XfPage page, Test9 test9) {
    return XfR.ok(test9ServiceImpl.page(page, Wrappers.query(test9)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test9s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test9ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test9 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test9s")
  public XfR save(@RequestBody Test9 test9) {
     return XfR.ok(test9ServiceImpl.save(test9));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test9 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test9s/{id}")
  public XfR putUpdate(@RequestBody Test9 test9,@PathVariable Long id) {
      test9.setId(id);
      return XfR.ok(test9ServiceImpl.updateById(test9));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test9 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test9s/{id}")
  public XfR patchUpdate(@RequestBody Test9 test9,@PathVariable Long id) {
      Test9 uptest9 = test9ServiceImpl.getById(id);
      if(uptest9 != null){
        uptest9 = ObjectCopyUtils.copyProperties(test9,uptest9,true);
      }
      return XfR.ok(test9ServiceImpl.updateById(uptest9));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test9s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test9ServiceImpl.removeById(id));
  }

  @PostMapping("/test9s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test9");
     params.put("request", condition);

     return XfR.ok(test9ServiceImpl.querys(params));
  }

}
