package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.TestEntendToOne;
import com.xforceplus.ultraman.app.sdktest.service.ITestEntendToOneService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestEntendToOneController {

  @Autowired
  private ITestEntendToOneService testEntendToOneServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testEntendToOne ${table.comment}
   * @return
   */
  @GetMapping("/testentendtoones" )
  public XfR getTestEntendToOnes(XfPage page, TestEntendToOne testEntendToOne) {
    return XfR.ok(testEntendToOneServiceImpl.page(page, Wrappers.query(testEntendToOne)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testentendtoones/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testEntendToOneServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testEntendToOne ${table.comment}
   * @return XfR
   */
  @PostMapping("/testentendtoones")
  public XfR save(@RequestBody TestEntendToOne testEntendToOne) {
     return XfR.ok(testEntendToOneServiceImpl.save(testEntendToOne));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testEntendToOne ${table.comment}
   * @return XfR
   */
  @PutMapping("/testentendtoones/{id}")
  public XfR putUpdate(@RequestBody TestEntendToOne testEntendToOne,@PathVariable Long id) {
      testEntendToOne.setId(id);
      return XfR.ok(testEntendToOneServiceImpl.updateById(testEntendToOne));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testEntendToOne ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testentendtoones/{id}")
  public XfR patchUpdate(@RequestBody TestEntendToOne testEntendToOne,@PathVariable Long id) {
      TestEntendToOne uptestEntendToOne = testEntendToOneServiceImpl.getById(id);
      if(uptestEntendToOne != null){
        uptestEntendToOne = ObjectCopyUtils.copyProperties(testEntendToOne,uptestEntendToOne,true);
      }
      return XfR.ok(testEntendToOneServiceImpl.updateById(uptestEntendToOne));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testentendtoones/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testEntendToOneServiceImpl.removeById(id));
  }

  @PostMapping("/testentendtoones/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_entend_to_one");
     params.put("request", condition);

     return XfR.ok(testEntendToOneServiceImpl.querys(params));
  }

}
