package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.TestExtendChild1Child;
import com.xforceplus.ultraman.app.sdktest.service.ITestExtendChild1ChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestExtendChild1ChildController {

  @Autowired
  private ITestExtendChild1ChildService testExtendChild1ChildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testExtendChild1Child ${table.comment}
   * @return
   */
  @GetMapping("/testextendchild1childs" )
  public XfR getTestExtendChild1Childs(XfPage page, TestExtendChild1Child testExtendChild1Child) {
    return XfR.ok(testExtendChild1ChildServiceImpl.page(page, Wrappers.query(testExtendChild1Child)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testextendchild1childs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testExtendChild1ChildServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testExtendChild1Child ${table.comment}
   * @return XfR
   */
  @PostMapping("/testextendchild1childs")
  public XfR save(@RequestBody TestExtendChild1Child testExtendChild1Child) {
     return XfR.ok(testExtendChild1ChildServiceImpl.save(testExtendChild1Child));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testExtendChild1Child ${table.comment}
   * @return XfR
   */
  @PutMapping("/testextendchild1childs/{id}")
  public XfR putUpdate(@RequestBody TestExtendChild1Child testExtendChild1Child,@PathVariable Long id) {
      testExtendChild1Child.setId(id);
      return XfR.ok(testExtendChild1ChildServiceImpl.updateById(testExtendChild1Child));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testExtendChild1Child ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testextendchild1childs/{id}")
  public XfR patchUpdate(@RequestBody TestExtendChild1Child testExtendChild1Child,@PathVariable Long id) {
      TestExtendChild1Child uptestExtendChild1Child = testExtendChild1ChildServiceImpl.getById(id);
      if(uptestExtendChild1Child != null){
        uptestExtendChild1Child = ObjectCopyUtils.copyProperties(testExtendChild1Child,uptestExtendChild1Child,true);
      }
      return XfR.ok(testExtendChild1ChildServiceImpl.updateById(uptestExtendChild1Child));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testextendchild1childs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testExtendChild1ChildServiceImpl.removeById(id));
  }

  @PostMapping("/testextendchild1childs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_extend_child1_child");
     params.put("request", condition);

     return XfR.ok(testExtendChild1ChildServiceImpl.querys(params));
  }

}
