package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.TestExtendMain;
import com.xforceplus.ultraman.app.sdktest.service.ITestExtendMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestExtendMainController {

  @Autowired
  private ITestExtendMainService testExtendMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testExtendMain ${table.comment}
   * @return
   */
  @GetMapping("/testextendmains" )
  public XfR getTestExtendMains(XfPage page, TestExtendMain testExtendMain) {
    return XfR.ok(testExtendMainServiceImpl.page(page, Wrappers.query(testExtendMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testextendmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testExtendMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testExtendMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/testextendmains")
  public XfR save(@RequestBody TestExtendMain testExtendMain) {
     return XfR.ok(testExtendMainServiceImpl.save(testExtendMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testExtendMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/testextendmains/{id}")
  public XfR putUpdate(@RequestBody TestExtendMain testExtendMain,@PathVariable Long id) {
      testExtendMain.setId(id);
      return XfR.ok(testExtendMainServiceImpl.updateById(testExtendMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testExtendMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testextendmains/{id}")
  public XfR patchUpdate(@RequestBody TestExtendMain testExtendMain,@PathVariable Long id) {
      TestExtendMain uptestExtendMain = testExtendMainServiceImpl.getById(id);
      if(uptestExtendMain != null){
        uptestExtendMain = ObjectCopyUtils.copyProperties(testExtendMain,uptestExtendMain,true);
      }
      return XfR.ok(testExtendMainServiceImpl.updateById(uptestExtendMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testextendmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testExtendMainServiceImpl.removeById(id));
  }

  @PostMapping("/testextendmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_extend_main");
     params.put("request", condition);

     return XfR.ok(testExtendMainServiceImpl.querys(params));
  }

}
