package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.TestExtendToManyChild;
import com.xforceplus.ultraman.app.sdktest.service.ITestExtendToManyChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestExtendToManyChildController {

  @Autowired
  private ITestExtendToManyChildService testExtendToManyChildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testExtendToManyChild ${table.comment}
   * @return
   */
  @GetMapping("/testextendtomanychilds" )
  public XfR getTestExtendToManyChilds(XfPage page, TestExtendToManyChild testExtendToManyChild) {
    return XfR.ok(testExtendToManyChildServiceImpl.page(page, Wrappers.query(testExtendToManyChild)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testextendtomanychilds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testExtendToManyChildServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testExtendToManyChild ${table.comment}
   * @return XfR
   */
  @PostMapping("/testextendtomanychilds")
  public XfR save(@RequestBody TestExtendToManyChild testExtendToManyChild) {
     return XfR.ok(testExtendToManyChildServiceImpl.save(testExtendToManyChild));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testExtendToManyChild ${table.comment}
   * @return XfR
   */
  @PutMapping("/testextendtomanychilds/{id}")
  public XfR putUpdate(@RequestBody TestExtendToManyChild testExtendToManyChild,@PathVariable Long id) {
      testExtendToManyChild.setId(id);
      return XfR.ok(testExtendToManyChildServiceImpl.updateById(testExtendToManyChild));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testExtendToManyChild ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testextendtomanychilds/{id}")
  public XfR patchUpdate(@RequestBody TestExtendToManyChild testExtendToManyChild,@PathVariable Long id) {
      TestExtendToManyChild uptestExtendToManyChild = testExtendToManyChildServiceImpl.getById(id);
      if(uptestExtendToManyChild != null){
        uptestExtendToManyChild = ObjectCopyUtils.copyProperties(testExtendToManyChild,uptestExtendToManyChild,true);
      }
      return XfR.ok(testExtendToManyChildServiceImpl.updateById(uptestExtendToManyChild));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testextendtomanychilds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testExtendToManyChildServiceImpl.removeById(id));
  }

  @PostMapping("/testextendtomanychilds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_extend_to_many_child");
     params.put("request", condition);

     return XfR.ok(testExtendToManyChildServiceImpl.querys(params));
  }

}
