package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.TestExtendToMany;
import com.xforceplus.ultraman.app.sdktest.service.ITestExtendToManyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestExtendToManyController {

  @Autowired
  private ITestExtendToManyService testExtendToManyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testExtendToMany ${table.comment}
   * @return
   */
  @GetMapping("/testextendtomanys" )
  public XfR getTestExtendToManys(XfPage page, TestExtendToMany testExtendToMany) {
    return XfR.ok(testExtendToManyServiceImpl.page(page, Wrappers.query(testExtendToMany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testextendtomanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testExtendToManyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testExtendToMany ${table.comment}
   * @return XfR
   */
  @PostMapping("/testextendtomanys")
  public XfR save(@RequestBody TestExtendToMany testExtendToMany) {
     return XfR.ok(testExtendToManyServiceImpl.save(testExtendToMany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testExtendToMany ${table.comment}
   * @return XfR
   */
  @PutMapping("/testextendtomanys/{id}")
  public XfR putUpdate(@RequestBody TestExtendToMany testExtendToMany,@PathVariable Long id) {
      testExtendToMany.setId(id);
      return XfR.ok(testExtendToManyServiceImpl.updateById(testExtendToMany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testExtendToMany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testextendtomanys/{id}")
  public XfR patchUpdate(@RequestBody TestExtendToMany testExtendToMany,@PathVariable Long id) {
      TestExtendToMany uptestExtendToMany = testExtendToManyServiceImpl.getById(id);
      if(uptestExtendToMany != null){
        uptestExtendToMany = ObjectCopyUtils.copyProperties(testExtendToMany,uptestExtendToMany,true);
      }
      return XfR.ok(testExtendToManyServiceImpl.updateById(uptestExtendToMany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testextendtomanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testExtendToManyServiceImpl.removeById(id));
  }

  @PostMapping("/testextendtomanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_extend_to_many");
     params.put("request", condition);

     return XfR.ok(testExtendToManyServiceImpl.querys(params));
  }

}
