package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.TestExtendToManyToOne;
import com.xforceplus.ultraman.app.sdktest.service.ITestExtendToManyToOneService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestExtendToManyToOneController {

  @Autowired
  private ITestExtendToManyToOneService testExtendToManyToOneServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testExtendToManyToOne ${table.comment}
   * @return
   */
  @GetMapping("/testextendtomanytoones" )
  public XfR getTestExtendToManyToOnes(XfPage page, TestExtendToManyToOne testExtendToManyToOne) {
    return XfR.ok(testExtendToManyToOneServiceImpl.page(page, Wrappers.query(testExtendToManyToOne)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testextendtomanytoones/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testExtendToManyToOneServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testExtendToManyToOne ${table.comment}
   * @return XfR
   */
  @PostMapping("/testextendtomanytoones")
  public XfR save(@RequestBody TestExtendToManyToOne testExtendToManyToOne) {
     return XfR.ok(testExtendToManyToOneServiceImpl.save(testExtendToManyToOne));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testExtendToManyToOne ${table.comment}
   * @return XfR
   */
  @PutMapping("/testextendtomanytoones/{id}")
  public XfR putUpdate(@RequestBody TestExtendToManyToOne testExtendToManyToOne,@PathVariable Long id) {
      testExtendToManyToOne.setId(id);
      return XfR.ok(testExtendToManyToOneServiceImpl.updateById(testExtendToManyToOne));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testExtendToManyToOne ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testextendtomanytoones/{id}")
  public XfR patchUpdate(@RequestBody TestExtendToManyToOne testExtendToManyToOne,@PathVariable Long id) {
      TestExtendToManyToOne uptestExtendToManyToOne = testExtendToManyToOneServiceImpl.getById(id);
      if(uptestExtendToManyToOne != null){
        uptestExtendToManyToOne = ObjectCopyUtils.copyProperties(testExtendToManyToOne,uptestExtendToManyToOne,true);
      }
      return XfR.ok(testExtendToManyToOneServiceImpl.updateById(uptestExtendToManyToOne));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testextendtomanytoones/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testExtendToManyToOneServiceImpl.removeById(id));
  }

  @PostMapping("/testextendtomanytoones/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_extend_to_many_to_one");
     params.put("request", condition);

     return XfR.ok(testExtendToManyToOneServiceImpl.querys(params));
  }

}
