package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.TestExtendToOneChild;
import com.xforceplus.ultraman.app.sdktest.service.ITestExtendToOneChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestExtendToOneChildController {

  @Autowired
  private ITestExtendToOneChildService testExtendToOneChildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testExtendToOneChild ${table.comment}
   * @return
   */
  @GetMapping("/testextendtoonechilds" )
  public XfR getTestExtendToOneChilds(XfPage page, TestExtendToOneChild testExtendToOneChild) {
    return XfR.ok(testExtendToOneChildServiceImpl.page(page, Wrappers.query(testExtendToOneChild)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testextendtoonechilds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testExtendToOneChildServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testExtendToOneChild ${table.comment}
   * @return XfR
   */
  @PostMapping("/testextendtoonechilds")
  public XfR save(@RequestBody TestExtendToOneChild testExtendToOneChild) {
     return XfR.ok(testExtendToOneChildServiceImpl.save(testExtendToOneChild));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testExtendToOneChild ${table.comment}
   * @return XfR
   */
  @PutMapping("/testextendtoonechilds/{id}")
  public XfR putUpdate(@RequestBody TestExtendToOneChild testExtendToOneChild,@PathVariable Long id) {
      testExtendToOneChild.setId(id);
      return XfR.ok(testExtendToOneChildServiceImpl.updateById(testExtendToOneChild));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testExtendToOneChild ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testextendtoonechilds/{id}")
  public XfR patchUpdate(@RequestBody TestExtendToOneChild testExtendToOneChild,@PathVariable Long id) {
      TestExtendToOneChild uptestExtendToOneChild = testExtendToOneChildServiceImpl.getById(id);
      if(uptestExtendToOneChild != null){
        uptestExtendToOneChild = ObjectCopyUtils.copyProperties(testExtendToOneChild,uptestExtendToOneChild,true);
      }
      return XfR.ok(testExtendToOneChildServiceImpl.updateById(uptestExtendToOneChild));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testextendtoonechilds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testExtendToOneChildServiceImpl.removeById(id));
  }

  @PostMapping("/testextendtoonechilds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_extend_to_one_child");
     params.put("request", condition);

     return XfR.ok(testExtendToOneChildServiceImpl.querys(params));
  }

}
