package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testa;
import com.xforceplus.ultraman.app.sdktest.service.ITestaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestaController {

  @Autowired
  private ITestaService testaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testa ${table.comment}
   * @return
   */
  @GetMapping("/testas" )
  public XfR getTestas(XfPage page, Testa testa) {
    return XfR.ok(testaServiceImpl.page(page, Wrappers.query(testa)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testa ${table.comment}
   * @return XfR
   */
  @PostMapping("/testas")
  public XfR save(@RequestBody Testa testa) {
     return XfR.ok(testaServiceImpl.save(testa));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testa ${table.comment}
   * @return XfR
   */
  @PutMapping("/testas/{id}")
  public XfR putUpdate(@RequestBody Testa testa,@PathVariable Long id) {
      testa.setId(id);
      return XfR.ok(testaServiceImpl.updateById(testa));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testa ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testas/{id}")
  public XfR patchUpdate(@RequestBody Testa testa,@PathVariable Long id) {
      Testa uptesta = testaServiceImpl.getById(id);
      if(uptesta != null){
        uptesta = ObjectCopyUtils.copyProperties(testa,uptesta,true);
      }
      return XfR.ok(testaServiceImpl.updateById(uptesta));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testaServiceImpl.removeById(id));
  }

  @PostMapping("/testas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testa");
     params.put("request", condition);

     return XfR.ok(testaServiceImpl.querys(params));
  }

}
