package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testb;
import com.xforceplus.ultraman.app.sdktest.service.ITestbService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestbController {

  @Autowired
  private ITestbService testbServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testb ${table.comment}
   * @return
   */
  @GetMapping("/testbs" )
  public XfR getTestbs(XfPage page, Testb testb) {
    return XfR.ok(testbServiceImpl.page(page, Wrappers.query(testb)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testbServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testb ${table.comment}
   * @return XfR
   */
  @PostMapping("/testbs")
  public XfR save(@RequestBody Testb testb) {
     return XfR.ok(testbServiceImpl.save(testb));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testb ${table.comment}
   * @return XfR
   */
  @PutMapping("/testbs/{id}")
  public XfR putUpdate(@RequestBody Testb testb,@PathVariable Long id) {
      testb.setId(id);
      return XfR.ok(testbServiceImpl.updateById(testb));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testb ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testbs/{id}")
  public XfR patchUpdate(@RequestBody Testb testb,@PathVariable Long id) {
      Testb uptestb = testbServiceImpl.getById(id);
      if(uptestb != null){
        uptestb = ObjectCopyUtils.copyProperties(testb,uptestb,true);
      }
      return XfR.ok(testbServiceImpl.updateById(uptestb));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testbServiceImpl.removeById(id));
  }

  @PostMapping("/testbs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testb");
     params.put("request", condition);

     return XfR.ok(testbServiceImpl.querys(params));
  }

}
