package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testdefault;
import com.xforceplus.ultraman.app.sdktest.service.ITestdefaultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class TestdefaultController {

  @Autowired
  private ITestdefaultService testdefaultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdefault ${table.comment}
   * @return
   */
  @GetMapping("/testdefaults" )
  public XfR getTestdefaults(XfPage page, Testdefault testdefault) {
    return XfR.ok(testdefaultServiceImpl.page(page, Wrappers.query(testdefault)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdefaults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdefaultServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdefault ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdefaults")
  public XfR save(@RequestBody Testdefault testdefault) {
     return XfR.ok(testdefaultServiceImpl.save(testdefault));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdefault ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdefaults/{id}")
  public XfR putUpdate(@RequestBody Testdefault testdefault,@PathVariable Long id) {
      testdefault.setId(id);
      return XfR.ok(testdefaultServiceImpl.updateById(testdefault));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdefault ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdefaults/{id}")
  public XfR patchUpdate(@RequestBody Testdefault testdefault,@PathVariable Long id) {
      Testdefault uptestdefault = testdefaultServiceImpl.getById(id);
      if(uptestdefault != null){
        uptestdefault = ObjectCopyUtils.copyProperties(testdefault,uptestdefault,true);
      }
      return XfR.ok(testdefaultServiceImpl.updateById(uptestdefault));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdefaults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdefaultServiceImpl.removeById(id));
  }

  @PostMapping("/testdefaults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdefault");
     params.put("request", condition);

     return XfR.ok(testdefaultServiceImpl.querys(params));
  }

}
