package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testdomainno01;
import com.xforceplus.ultraman.app.sdktest.service.ITestdomainno01Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Testdomainno01Controller {

  @Autowired
  private ITestdomainno01Service testdomainno01ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdomainno01 ${table.comment}
   * @return
   */
  @GetMapping("/testdomainno01s" )
  public XfR getTestdomainno01s(XfPage page, Testdomainno01 testdomainno01) {
    return XfR.ok(testdomainno01ServiceImpl.page(page, Wrappers.query(testdomainno01)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdomainno01s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdomainno01ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdomainno01 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdomainno01s")
  public XfR save(@RequestBody Testdomainno01 testdomainno01) {
     return XfR.ok(testdomainno01ServiceImpl.save(testdomainno01));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdomainno01 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdomainno01s/{id}")
  public XfR putUpdate(@RequestBody Testdomainno01 testdomainno01,@PathVariable Long id) {
      testdomainno01.setId(id);
      return XfR.ok(testdomainno01ServiceImpl.updateById(testdomainno01));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdomainno01 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdomainno01s/{id}")
  public XfR patchUpdate(@RequestBody Testdomainno01 testdomainno01,@PathVariable Long id) {
      Testdomainno01 uptestdomainno01 = testdomainno01ServiceImpl.getById(id);
      if(uptestdomainno01 != null){
        uptestdomainno01 = ObjectCopyUtils.copyProperties(testdomainno01,uptestdomainno01,true);
      }
      return XfR.ok(testdomainno01ServiceImpl.updateById(uptestdomainno01));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdomainno01s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdomainno01ServiceImpl.removeById(id));
  }

  @PostMapping("/testdomainno01s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdomainno01");
     params.put("request", condition);

     return XfR.ok(testdomainno01ServiceImpl.querys(params));
  }

}
