package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testdomainno02;
import com.xforceplus.ultraman.app.sdktest.service.ITestdomainno02Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Testdomainno02Controller {

  @Autowired
  private ITestdomainno02Service testdomainno02ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdomainno02 ${table.comment}
   * @return
   */
  @GetMapping("/testdomainno02s" )
  public XfR getTestdomainno02s(XfPage page, Testdomainno02 testdomainno02) {
    return XfR.ok(testdomainno02ServiceImpl.page(page, Wrappers.query(testdomainno02)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdomainno02s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdomainno02ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdomainno02 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdomainno02s")
  public XfR save(@RequestBody Testdomainno02 testdomainno02) {
     return XfR.ok(testdomainno02ServiceImpl.save(testdomainno02));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdomainno02 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdomainno02s/{id}")
  public XfR putUpdate(@RequestBody Testdomainno02 testdomainno02,@PathVariable Long id) {
      testdomainno02.setId(id);
      return XfR.ok(testdomainno02ServiceImpl.updateById(testdomainno02));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdomainno02 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdomainno02s/{id}")
  public XfR patchUpdate(@RequestBody Testdomainno02 testdomainno02,@PathVariable Long id) {
      Testdomainno02 uptestdomainno02 = testdomainno02ServiceImpl.getById(id);
      if(uptestdomainno02 != null){
        uptestdomainno02 = ObjectCopyUtils.copyProperties(testdomainno02,uptestdomainno02,true);
      }
      return XfR.ok(testdomainno02ServiceImpl.updateById(uptestdomainno02));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdomainno02s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdomainno02ServiceImpl.removeById(id));
  }

  @PostMapping("/testdomainno02s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdomainno02");
     params.put("request", condition);

     return XfR.ok(testdomainno02ServiceImpl.querys(params));
  }

}
