package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testdomainno03;
import com.xforceplus.ultraman.app.sdktest.service.ITestdomainno03Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Testdomainno03Controller {

  @Autowired
  private ITestdomainno03Service testdomainno03ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdomainno03 ${table.comment}
   * @return
   */
  @GetMapping("/testdomainno03s" )
  public XfR getTestdomainno03s(XfPage page, Testdomainno03 testdomainno03) {
    return XfR.ok(testdomainno03ServiceImpl.page(page, Wrappers.query(testdomainno03)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdomainno03s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdomainno03ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdomainno03 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdomainno03s")
  public XfR save(@RequestBody Testdomainno03 testdomainno03) {
     return XfR.ok(testdomainno03ServiceImpl.save(testdomainno03));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdomainno03 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdomainno03s/{id}")
  public XfR putUpdate(@RequestBody Testdomainno03 testdomainno03,@PathVariable Long id) {
      testdomainno03.setId(id);
      return XfR.ok(testdomainno03ServiceImpl.updateById(testdomainno03));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdomainno03 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdomainno03s/{id}")
  public XfR patchUpdate(@RequestBody Testdomainno03 testdomainno03,@PathVariable Long id) {
      Testdomainno03 uptestdomainno03 = testdomainno03ServiceImpl.getById(id);
      if(uptestdomainno03 != null){
        uptestdomainno03 = ObjectCopyUtils.copyProperties(testdomainno03,uptestdomainno03,true);
      }
      return XfR.ok(testdomainno03ServiceImpl.updateById(uptestdomainno03));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdomainno03s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdomainno03ServiceImpl.removeById(id));
  }

  @PostMapping("/testdomainno03s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdomainno03");
     params.put("request", condition);

     return XfR.ok(testdomainno03ServiceImpl.querys(params));
  }

}
