package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testdomainno05;
import com.xforceplus.ultraman.app.sdktest.service.ITestdomainno05Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Testdomainno05Controller {

  @Autowired
  private ITestdomainno05Service testdomainno05ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdomainno05 ${table.comment}
   * @return
   */
  @GetMapping("/testdomainno05s" )
  public XfR getTestdomainno05s(XfPage page, Testdomainno05 testdomainno05) {
    return XfR.ok(testdomainno05ServiceImpl.page(page, Wrappers.query(testdomainno05)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdomainno05s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdomainno05ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdomainno05 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdomainno05s")
  public XfR save(@RequestBody Testdomainno05 testdomainno05) {
     return XfR.ok(testdomainno05ServiceImpl.save(testdomainno05));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdomainno05 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdomainno05s/{id}")
  public XfR putUpdate(@RequestBody Testdomainno05 testdomainno05,@PathVariable Long id) {
      testdomainno05.setId(id);
      return XfR.ok(testdomainno05ServiceImpl.updateById(testdomainno05));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdomainno05 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdomainno05s/{id}")
  public XfR patchUpdate(@RequestBody Testdomainno05 testdomainno05,@PathVariable Long id) {
      Testdomainno05 uptestdomainno05 = testdomainno05ServiceImpl.getById(id);
      if(uptestdomainno05 != null){
        uptestdomainno05 = ObjectCopyUtils.copyProperties(testdomainno05,uptestdomainno05,true);
      }
      return XfR.ok(testdomainno05ServiceImpl.updateById(uptestdomainno05));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdomainno05s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdomainno05ServiceImpl.removeById(id));
  }

  @PostMapping("/testdomainno05s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdomainno05");
     params.put("request", condition);

     return XfR.ok(testdomainno05ServiceImpl.querys(params));
  }

}
