package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testdomainno06;
import com.xforceplus.ultraman.app.sdktest.service.ITestdomainno06Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Testdomainno06Controller {

  @Autowired
  private ITestdomainno06Service testdomainno06ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdomainno06 ${table.comment}
   * @return
   */
  @GetMapping("/testdomainno06s" )
  public XfR getTestdomainno06s(XfPage page, Testdomainno06 testdomainno06) {
    return XfR.ok(testdomainno06ServiceImpl.page(page, Wrappers.query(testdomainno06)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdomainno06s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdomainno06ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdomainno06 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdomainno06s")
  public XfR save(@RequestBody Testdomainno06 testdomainno06) {
     return XfR.ok(testdomainno06ServiceImpl.save(testdomainno06));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdomainno06 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdomainno06s/{id}")
  public XfR putUpdate(@RequestBody Testdomainno06 testdomainno06,@PathVariable Long id) {
      testdomainno06.setId(id);
      return XfR.ok(testdomainno06ServiceImpl.updateById(testdomainno06));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdomainno06 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdomainno06s/{id}")
  public XfR patchUpdate(@RequestBody Testdomainno06 testdomainno06,@PathVariable Long id) {
      Testdomainno06 uptestdomainno06 = testdomainno06ServiceImpl.getById(id);
      if(uptestdomainno06 != null){
        uptestdomainno06 = ObjectCopyUtils.copyProperties(testdomainno06,uptestdomainno06,true);
      }
      return XfR.ok(testdomainno06ServiceImpl.updateById(uptestdomainno06));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdomainno06s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdomainno06ServiceImpl.removeById(id));
  }

  @PostMapping("/testdomainno06s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdomainno06");
     params.put("request", condition);

     return XfR.ok(testdomainno06ServiceImpl.querys(params));
  }

}
