package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testlookup01;
import com.xforceplus.ultraman.app.sdktest.service.ITestlookup01Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Testlookup01Controller {

  @Autowired
  private ITestlookup01Service testlookup01ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testlookup01 ${table.comment}
   * @return
   */
  @GetMapping("/testlookup01s" )
  public XfR getTestlookup01s(XfPage page, Testlookup01 testlookup01) {
    return XfR.ok(testlookup01ServiceImpl.page(page, Wrappers.query(testlookup01)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testlookup01s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testlookup01ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testlookup01 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testlookup01s")
  public XfR save(@RequestBody Testlookup01 testlookup01) {
     return XfR.ok(testlookup01ServiceImpl.save(testlookup01));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testlookup01 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testlookup01s/{id}")
  public XfR putUpdate(@RequestBody Testlookup01 testlookup01,@PathVariable Long id) {
      testlookup01.setId(id);
      return XfR.ok(testlookup01ServiceImpl.updateById(testlookup01));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testlookup01 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testlookup01s/{id}")
  public XfR patchUpdate(@RequestBody Testlookup01 testlookup01,@PathVariable Long id) {
      Testlookup01 uptestlookup01 = testlookup01ServiceImpl.getById(id);
      if(uptestlookup01 != null){
        uptestlookup01 = ObjectCopyUtils.copyProperties(testlookup01,uptestlookup01,true);
      }
      return XfR.ok(testlookup01ServiceImpl.updateById(uptestlookup01));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testlookup01s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testlookup01ServiceImpl.removeById(id));
  }

  @PostMapping("/testlookup01s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testlookup01");
     params.put("request", condition);

     return XfR.ok(testlookup01ServiceImpl.querys(params));
  }

}
