package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Testsave7;
import com.xforceplus.ultraman.app.sdktest.service.ITestsave7Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Testsave7Controller {

  @Autowired
  private ITestsave7Service testsave7ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testsave7 ${table.comment}
   * @return
   */
  @GetMapping("/testsave7s" )
  public XfR getTestsave7s(XfPage page, Testsave7 testsave7) {
    return XfR.ok(testsave7ServiceImpl.page(page, Wrappers.query(testsave7)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testsave7s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testsave7ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testsave7 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testsave7s")
  public XfR save(@RequestBody Testsave7 testsave7) {
     return XfR.ok(testsave7ServiceImpl.save(testsave7));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testsave7 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testsave7s/{id}")
  public XfR putUpdate(@RequestBody Testsave7 testsave7,@PathVariable Long id) {
      testsave7.setId(id);
      return XfR.ok(testsave7ServiceImpl.updateById(testsave7));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testsave7 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testsave7s/{id}")
  public XfR patchUpdate(@RequestBody Testsave7 testsave7,@PathVariable Long id) {
      Testsave7 uptestsave7 = testsave7ServiceImpl.getById(id);
      if(uptestsave7 != null){
        uptestsave7 = ObjectCopyUtils.copyProperties(testsave7,uptestsave7,true);
      }
      return XfR.ok(testsave7ServiceImpl.updateById(uptestsave7));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testsave7s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testsave7ServiceImpl.removeById(id));
  }

  @PostMapping("/testsave7s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testsave7");
     params.put("request", condition);

     return XfR.ok(testsave7ServiceImpl.querys(params));
  }

}
