package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Tf070901;
import com.xforceplus.ultraman.app.sdktest.service.ITf070901Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Tf070901Controller {

  @Autowired
  private ITf070901Service tf070901ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tf070901 ${table.comment}
   * @return
   */
  @GetMapping("/tf070901s" )
  public XfR getTf070901s(XfPage page, Tf070901 tf070901) {
    return XfR.ok(tf070901ServiceImpl.page(page, Wrappers.query(tf070901)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tf070901s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tf070901ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tf070901 ${table.comment}
   * @return XfR
   */
  @PostMapping("/tf070901s")
  public XfR save(@RequestBody Tf070901 tf070901) {
     return XfR.ok(tf070901ServiceImpl.save(tf070901));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tf070901 ${table.comment}
   * @return XfR
   */
  @PutMapping("/tf070901s/{id}")
  public XfR putUpdate(@RequestBody Tf070901 tf070901,@PathVariable Long id) {
      tf070901.setId(id);
      return XfR.ok(tf070901ServiceImpl.updateById(tf070901));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tf070901 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tf070901s/{id}")
  public XfR patchUpdate(@RequestBody Tf070901 tf070901,@PathVariable Long id) {
      Tf070901 uptf070901 = tf070901ServiceImpl.getById(id);
      if(uptf070901 != null){
        uptf070901 = ObjectCopyUtils.copyProperties(tf070901,uptf070901,true);
      }
      return XfR.ok(tf070901ServiceImpl.updateById(uptf070901));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tf070901s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tf070901ServiceImpl.removeById(id));
  }

  @PostMapping("/tf070901s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tf070901");
     params.put("request", condition);

     return XfR.ok(tf070901ServiceImpl.querys(params));
  }

}
