package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Tf070902;
import com.xforceplus.ultraman.app.sdktest.service.ITf070902Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Tf070902Controller {

  @Autowired
  private ITf070902Service tf070902ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tf070902 ${table.comment}
   * @return
   */
  @GetMapping("/tf070902s" )
  public XfR getTf070902s(XfPage page, Tf070902 tf070902) {
    return XfR.ok(tf070902ServiceImpl.page(page, Wrappers.query(tf070902)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tf070902s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tf070902ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tf070902 ${table.comment}
   * @return XfR
   */
  @PostMapping("/tf070902s")
  public XfR save(@RequestBody Tf070902 tf070902) {
     return XfR.ok(tf070902ServiceImpl.save(tf070902));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tf070902 ${table.comment}
   * @return XfR
   */
  @PutMapping("/tf070902s/{id}")
  public XfR putUpdate(@RequestBody Tf070902 tf070902,@PathVariable Long id) {
      tf070902.setId(id);
      return XfR.ok(tf070902ServiceImpl.updateById(tf070902));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tf070902 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tf070902s/{id}")
  public XfR patchUpdate(@RequestBody Tf070902 tf070902,@PathVariable Long id) {
      Tf070902 uptf070902 = tf070902ServiceImpl.getById(id);
      if(uptf070902 != null){
        uptf070902 = ObjectCopyUtils.copyProperties(tf070902,uptf070902,true);
      }
      return XfR.ok(tf070902ServiceImpl.updateById(uptf070902));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tf070902s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tf070902ServiceImpl.removeById(id));
  }

  @PostMapping("/tf070902s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tf070902");
     params.put("request", condition);

     return XfR.ok(tf070902ServiceImpl.querys(params));
  }

}
