package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Tf071301;
import com.xforceplus.ultraman.app.sdktest.service.ITf071301Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Tf071301Controller {

  @Autowired
  private ITf071301Service tf071301ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tf071301 ${table.comment}
   * @return
   */
  @GetMapping("/tf071301s" )
  public XfR getTf071301s(XfPage page, Tf071301 tf071301) {
    return XfR.ok(tf071301ServiceImpl.page(page, Wrappers.query(tf071301)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tf071301s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tf071301ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tf071301 ${table.comment}
   * @return XfR
   */
  @PostMapping("/tf071301s")
  public XfR save(@RequestBody Tf071301 tf071301) {
     return XfR.ok(tf071301ServiceImpl.save(tf071301));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tf071301 ${table.comment}
   * @return XfR
   */
  @PutMapping("/tf071301s/{id}")
  public XfR putUpdate(@RequestBody Tf071301 tf071301,@PathVariable Long id) {
      tf071301.setId(id);
      return XfR.ok(tf071301ServiceImpl.updateById(tf071301));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tf071301 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tf071301s/{id}")
  public XfR patchUpdate(@RequestBody Tf071301 tf071301,@PathVariable Long id) {
      Tf071301 uptf071301 = tf071301ServiceImpl.getById(id);
      if(uptf071301 != null){
        uptf071301 = ObjectCopyUtils.copyProperties(tf071301,uptf071301,true);
      }
      return XfR.ok(tf071301ServiceImpl.updateById(uptf071301));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tf071301s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tf071301ServiceImpl.removeById(id));
  }

  @PostMapping("/tf071301s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tf071301");
     params.put("request", condition);

     return XfR.ok(tf071301ServiceImpl.querys(params));
  }

}
